<?php

class UserTeacherIdentity extends CUserIdentity
{
	private $id;

	public function authenticate()
	{
		$userModel = Admin::model()->findByAttributes(array('login'=>$this->username,'rodzaj'=>'1'));
		$this->errorCode = self::ERROR_USERNAME_INVALID;

		if($userModel === null)
			$this->errorCode=self::ERROR_USERNAME_INVALID;
		else if(hash('sha1', $this->password) !== $userModel->haslo)
			$this->errorCode=self::ERROR_PASSWORD_INVALID;
		else
		{
			$this->errorCode = self::ERROR_NONE;

			$this->setState('type', 1);
			$this->id = $userModel->id;
			$this->username = $userModel->login;
			$this->setState('name',$userModel->imie);
			$this->setState('surname',$userModel->nazwisko);
			$this->setState('role','teacher');
		}

		return $this->errorCode == self::ERROR_NONE;
	}

	public function getId()
	{
		return $this->id;
	}
}